; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "JDAS"
#define MyAppVersion "2.83"
#define MySetupVersion "1.2"
#define MyAppPublisher "Yantai Jereh Petroleum Equipment & Technologies Co.,LTD"
#define MyAppURL "https://www.jereh-pe.com/"
#define MyAppSupportURL  "http://bsd235.ru"
#define MyAppExeName "JDAS.exe"

[Setup]
SetupLogging=no
; NOTE: The value of AppId uniquely identifies this application. Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
;--------------------------------------------------------------------------
;  GUID
; AppId={{91079267-21C1-4BF6-A726-52A12C4B21B2}
;
; :  3  =   JDAS
AppId={{91079267-21C1-4BF6-A726-52A12C4B2283}
;--------------------------------------------------------------------------
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppSupportURL}
;LicenseFile="{app}\license.txt"
InfoAfterFile="#_info_after.txt"
DefaultDirName=D:\{#MyAppName}-{#MyAppVersion}
DefaultGroupName={#MyAppName}-{#MyAppVersion}
; Uncomment the following line to run in non administrative install mode (install for current user only.)
;PrivilegesRequired=lowest
OutputDir=.
OutputBaseFilename={#MyAppName}-Setup-{#MyAppVersion}_v{#MySetupVersion}
SetupIconFile=..\JDAS-2_MAINICON.ico
Compression=lzma
SolidCompression=yes
WizardStyle=modern

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"

[Tasks]
;Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"

[Files]
Source: "{app}\{#MyAppExeName}"; DestDir: "{app}"; Flags: ignoreversion
Source: "{app}\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; AfterInstall: SetElevationBit('{group}\{#MyAppName}.lnk')
Name: "{group}\JDASHelp"; Filename: "{app}\JDAS_RU.pdf"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"
; Name: "{userdesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon
Name: "{commondesktop}\{#MyAppName}-{#MyAppVersion}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon; AfterInstall: SetElevationBit('{commondesktop}\{#MyAppName}-{#MyAppVersion}.lnk')

[Run]
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent runascurrentuser

; https://stackoverflow.com/questions/16978917/how-to-set-run-as-administrator-on-a-file-using-inno-setup
[Code]
procedure SetElevationBit(Filename: string);
var
  Buffer: string;
  Stream: TStream;
begin
  Filename := ExpandConstant(Filename);
  Log('Setting elevation bit for ' + Filename);

  Stream := TFileStream.Create(FileName, fmOpenReadWrite);
  try
    Stream.Seek(21, soFromBeginning);
    SetLength(Buffer, 1);
    Stream.ReadBuffer(Buffer, 1);
    Buffer[1] := Chr(Ord(Buffer[1]) or $20);
    Stream.Seek(-1, soFromCurrent);
    Stream.WriteBuffer(Buffer, 1);
  finally
    Stream.Free;
  end;
end;